/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.message;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.apps.designer.VWSolutionHelper;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.message.VWDesignerValidationItem;
import filenet.vw.toolkit.design.message.VWValidationPanel;
import filenet.vw.toolkit.design.message.VWValidationResultsDialog;
import filenet.vw.toolkit.design.message.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.swing.JPanel;

public class VWDesignerMessagePanel
extends JPanel {
    public static final int DISPLAY_TYPE_PANEL = 0;
    public static final int DISPLAY_TYPE_DIALOG = 1;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWValidationPanel m_validationPanel = null;
    private VWValidationResultsDialog m_validationDialog = null;

    public void init(VWAuthPropertyData authPropertyData, int nDisplayType) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setLayout(new BorderLayout(6, 6));
            switch (nDisplayType) {
                case 0: {
                    if (this.m_validationPanel != null) break;
                    this.m_validationPanel = new VWValidationPanel(this.m_authPropertyData.getMainContainer(), this);
                    this.add((Component)this.m_validationPanel, "Center");
                    break;
                }
                case 1: {
                    if (this.m_validationDialog != null) break;
                    this.m_validationDialog = new VWValidationResultsDialog(this.m_authPropertyData, this);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateProcess(VWAuthPropertyData authPropertyData, boolean bDisplayMessage) {
        try {
            VWDesignerValidationItem[] validationItems = null;
            if (authPropertyData != null && authPropertyData.getWorkflowDefinition() != null) {
                VWValidationError[] errors;
                VWWorkflowDefinition wflDef = authPropertyData.getWorkflowDefinition();
                VWSystemConfiguration sysConfig = authPropertyData.getDesignerCoreData().getDataDictionary().getSystemConfiguration();
                String sdfFileContents = null;
                VWSolutionHelper solutionHelper = this.m_authPropertyData.getDesignerCoreData().getSolutionHelper();
                if (solutionHelper != null) {
                    sdfFileContents = solutionHelper.getSdfFileContents();
                }
                if ((errors = wflDef.validate(authPropertyData.getVWSession(), sysConfig, sdfFileContents)) != null) {
                    validationItems = new VWDesignerValidationItem[errors.length];
                    for (int i = 0; i < errors.length; ++i) {
                        validationItems[i] = new VWDesignerValidationItem(errors[i], wflDef.getName(), 0);
                    }
                }
            }
            return this.evaluateValidationItems(validationItems, bDisplayMessage, 651);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            return false;
        }
    }

    public boolean validateProcessCollection(VWWorkflowCollectionDefinition wflCollectionDef, boolean bDisplayMessage) {
        try {
            Vector<VWDesignerValidationItem> items = new Vector<VWDesignerValidationItem>();
            if (this.m_authPropertyData != null) {
                HashMap errorMap;
                VWSystemConfiguration sysConfig = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getSystemConfiguration();
                String sdfFileContents = null;
                VWSolutionHelper solutionHelper = this.m_authPropertyData.getDesignerCoreData().getSolutionHelper();
                if (solutionHelper != null) {
                    sdfFileContents = solutionHelper.getSdfFileContents();
                }
                if ((errorMap = wflCollectionDef.validate(this.m_authPropertyData.getSessionInfo().getSession(), sysConfig, sdfFileContents)) != null && errorMap.size() > 0) {
                    for (Map.Entry mapentry : errorMap.entrySet()) {
                        VWValidationError[] errors;
                        int nSourceType = 0;
                        String sourceName = (String)mapentry.getKey();
                        if (VWStringUtils.compare(sourceName, "~CollectionKey") == 0) {
                            nSourceType = 1;
                        }
                        if ((errors = (VWValidationError[])mapentry.getValue()) == null || errors.length <= 0) continue;
                        for (int i = 0; i < errors.length; ++i) {
                            items.addElement(new VWDesignerValidationItem(errors[i], sourceName, nSourceType));
                        }
                    }
                }
            }
            Object[] validationItems = null;
            if (items.size() > 0) {
                validationItems = new VWDesignerValidationItem[items.size()];
                items.copyInto(validationItems);
            }
            return this.evaluateValidationItems((VWDesignerValidationItem[])validationItems, bDisplayMessage, 650);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            return false;
        }
    }

    public boolean examineReferences(VWWorkflowDefinition[] wflDefs, boolean bIsInheritanceEnabled) {
        try {
            Vector<VWDesignerValidationItem> items = new Vector<VWDesignerValidationItem>();
            if (this.m_authPropertyData != null && wflDefs != null) {
                for (int nIndex = 0; nIndex < wflDefs.length; ++nIndex) {
                    VWWorkflowDefinition wflDef = wflDefs[nIndex];
                    VWDesignerValidationItem[] validationItems = this.checkForIMSuiteReferences(wflDef);
                    if (validationItems == null || validationItems.length <= 0) continue;
                    for (int nErrorIndex = 0; nErrorIndex < validationItems.length; ++nErrorIndex) {
                        items.addElement(validationItems[nErrorIndex]);
                    }
                }
            }
            Object[] validationItems = null;
            if (items.size() > 0) {
                validationItems = new VWDesignerValidationItem[items.size()];
                items.copyInto(validationItems);
            }
            return this.evaluateValidationItems((VWDesignerValidationItem[])validationItems, true, 655);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            return false;
        }
    }

    public void releaseReferences() {
        if (this.m_validationPanel != null) {
            this.m_validationPanel.releaseReferences();
            this.m_validationPanel = null;
        }
        if (this.m_validationDialog != null) {
            this.m_validationDialog.setVisible(false);
            this.m_validationDialog = null;
        }
        this.m_authPropertyData = null;
    }

    protected void notifyListeners(VWDesignerValidationItem validationItem, VWWorkflowDefinition wflDef) {
        try {
            if (validationItem == null) {
                return;
            }
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 716, wflDef);
            VWMapDefinition vwMapDefinition = null;
            String mapName = validationItem.getMapName();
            if (mapName != null && wflDef != null) {
                vwMapDefinition = wflDef.getMap(mapName);
            }
            Object[] selectedItems = null;
            int nErrorType = validationItem.getErrorType();
            switch (nErrorType) {
                case 12: {
                    selectedItems = new Object[]{vwMapDefinition.getTextAnnotation(validationItem.getStepId()), mapName};
                    break;
                }
                case 4: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    selectedItems = new Object[]{wflDef, new Integer(nErrorType), validationItem.getName()};
                    break;
                }
                case 2: {
                    selectedItems = new Object[]{this.getRoute(vwMapDefinition, validationItem.getSubStepId()), mapName};
                    break;
                }
                case 1: 
                case 3: 
                case 7: {
                    selectedItems = new Object[]{vwMapDefinition.getStep(validationItem.getStepId()), mapName};
                    break;
                }
                case 13: {
                    this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 719, null);
                    return;
                }
            }
            this.m_authPropertyData.getDesignerCoreData().getCoordinationEventNotifier().sendCoordinationEvent(this, 718, selectedItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private VWRouteDefinition getRoute(VWMapDefinition vwMapDef, int routeID) {
        try {
            if (vwMapDef == null) {
                return null;
            }
            VWMapNode[] vwMapDefs = vwMapDef.getSteps();
            if (vwMapDefs == null) {
                return null;
            }
            for (int nIndex1 = 0; nIndex1 < vwMapDefs.length; ++nIndex1) {
                VWMapNode vwMapNode = vwMapDefs[nIndex1];
                VWRouteDefinition[] vwRouteDefs = vwMapNode.getNextRoutes();
                if (vwRouteDefs == null) continue;
                for (int nIndex2 = 0; nIndex2 < vwRouteDefs.length; ++nIndex2) {
                    VWRouteDefinition routeDef = vwRouteDefs[nIndex2];
                    if (routeDef == null || routeDef.getRouteId() != routeID) continue;
                    return routeDef;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    private boolean evaluateValidationItems(VWDesignerValidationItem[] validationItems, boolean bDisplayMessage, int nActionType) {
        boolean bValid = false;
        try {
            if (validationItems == null || validationItems.length == 0) {
                if (this.m_validationDialog != null) {
                    this.m_validationDialog.setVisible(false);
                }
                if (bDisplayMessage) {
                    String message = VWResource.s_validMessage;
                    if (nActionType == 655) {
                        message = VWResource.s_examinationSuccessful;
                    }
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), message, 2);
                }
                bValid = true;
            } else {
                int nWarningCount = 0;
                int nErrorCount = 0;
                block6: for (int nIndex = 0; nIndex < validationItems.length; ++nIndex) {
                    switch (validationItems[nIndex].getLevel()) {
                        case 2: {
                            ++nWarningCount;
                            continue block6;
                        }
                        case 1: {
                            ++nErrorCount;
                        }
                    }
                }
                if (nErrorCount > 0 && nWarningCount > 0) {
                    bValid = false;
                } else if (nErrorCount > 0) {
                    bValid = false;
                } else if (nWarningCount > 0) {
                    bValid = true;
                }
                if (this.m_validationDialog != null && (!bValid || bValid && bDisplayMessage)) {
                    this.m_validationDialog.setToolbarActionType(nActionType);
                    this.m_validationDialog.displayValidationMessages(validationItems, nErrorCount, nWarningCount);
                    this.m_validationDialog.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            return false;
        }
        return bValid;
    }

    private VWDesignerValidationItem[] checkForIMSuiteReferences(VWWorkflowDefinition wflDef) {
        try {
            if (wflDef == null) {
                return null;
            }
            Vector foundItems = new Vector();
            this.checkWorkflowFields(wflDef, foundItems);
            this.checkSteps(wflDef, foundItems);
            if (foundItems != null && foundItems.size() > 0) {
                Object[] validationItems = new VWDesignerValidationItem[foundItems.size()];
                foundItems.copyInto(validationItems);
                return validationItems;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
        return null;
    }

    private void checkWorkflowFields(VWWorkflowDefinition wflDef, Vector foundItems) {
        try {
            VWFieldDefinition[] fields = wflDef.getFields();
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    boolean bFound;
                    if (fields[i].getFieldType() != 32 || !(bFound = this.checkAttachmentFieldValue(fields[i].getValue(), fields[i].isArray()))) continue;
                    foundItems.addElement(new VWDesignerValidationItem(fields[i].getName(), 4, VWResource.s_incompatibleAttachment, null, wflDef.getName(), 0));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private boolean checkAttachmentFieldValue(Object value, boolean bIsArray) {
        boolean bFound = false;
        try {
            VWAttachment[] attArray = null;
            if (bIsArray) {
                if (value instanceof VWAttachment[]) {
                    attArray = (VWAttachment[])value;
                }
            } else if (value instanceof VWAttachment) {
                attArray = new VWAttachment[]{(VWAttachment)value};
            }
            if (attArray != null) {
                for (int j = 0; j < attArray.length && !(bFound = this.isIMSuiteId(attArray[j].getId())); ++j) {
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
        return bFound;
    }

    private boolean isIMSuiteId(String attachmentId) {
        try {
            if (attachmentId == null) {
                return false;
            }
            Integer.parseInt(attachmentId);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void checkSteps(VWWorkflowDefinition wflDef, Vector foundItems) {
        try {
            VWMapDefinition[] maps = wflDef.getMaps();
            if (maps != null) {
                int nFlags = 15;
                VWStepProcessorInfo[] stepProcessors = this.m_authPropertyData.getSessionInfo().getSession().fetchStepProcessors(nFlags);
                for (int i = 0; i < maps.length; ++i) {
                    VWMapNode[] steps = maps[i].getSteps();
                    if (steps == null) continue;
                    for (int j = 0; j < steps.length; ++j) {
                        VWMapNode stepDef;
                        if (steps[j] instanceof VWStepDefinition) {
                            stepDef = (VWStepDefinition)steps[j];
                            this.checkStepProcessor((VWStepDefinition)stepDef, maps[i].getName(), stepProcessors, wflDef.getName(), foundItems);
                            this.checkStepAssignments((VWStepDefinition)stepDef, ((VWStepDefinition)stepDef).getPreAssignments(), maps[i].getName(), wflDef, foundItems);
                            this.checkStepAssignments((VWStepDefinition)stepDef, ((VWStepDefinition)stepDef).getPostAssignments(), maps[i].getName(), wflDef, foundItems);
                            this.checkStepParameters((VWStepDefinition)stepDef, maps[i].getName(), wflDef, foundItems);
                            continue;
                        }
                        if (!(steps[j] instanceof VWCompoundStepDefinition)) continue;
                        stepDef = (VWCompoundStepDefinition)steps[j];
                        this.checkAssignmentInstructions((VWCompoundStepDefinition)stepDef, maps[i].getName(), wflDef, foundItems);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void checkStepProcessor(VWStepDefinition stepDef, String mapName, VWStepProcessorInfo[] stepProcessors, String wflName, Vector foundItems) {
        try {
            String spName = stepDef.getRequestedInterface();
            if (spName != null) {
                boolean bFoundStepProcessor = false;
                for (int nIndex = 0; nIndex < stepProcessors.length; ++nIndex) {
                    if (VWStringUtils.compare(spName, stepProcessors[nIndex].getName()) != 0) continue;
                    bFoundStepProcessor = true;
                    boolean bFoundP8Location = false;
                    Hashtable locationTable = stepProcessors[nIndex].getLocations();
                    if (locationTable != null && !locationTable.isEmpty()) {
                        Enumeration keyEnum = locationTable.keys();
                        while (keyEnum.hasMoreElements()) {
                            int nWebAppId = (Integer)keyEnum.nextElement();
                            if (!this.m_authPropertyData.getSessionInfo().isP8WebApp(nWebAppId)) continue;
                            bFoundP8Location = true;
                            break;
                        }
                    }
                    if (bFoundP8Location) break;
                    foundItems.addElement(new VWDesignerValidationItem(stepDef.getName(), 1, VWResource.s_incompatibleStepProcessor, spName, mapName, stepDef.getStepId(), wflName, 0));
                    break;
                }
                if (!bFoundStepProcessor) {
                    foundItems.addElement(new VWDesignerValidationItem(stepDef.getName(), 1, VWResource.s_stepProcessorNotFound, spName, mapName, stepDef.getStepId(), wflName, 0));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void checkStepAssignments(VWStepDefinition stepDef, String[][] stepAssignments, String mapName, VWWorkflowDefinition wflDef, Vector foundItems) {
        try {
            if (stepAssignments != null) {
                for (int i = 0; i < stepAssignments.length; ++i) {
                    boolean bFound;
                    VWFieldDefinition fieldDef = wflDef.getField(stepAssignments[i][0]);
                    if (fieldDef == null || fieldDef.getFieldType() != 32 || !(bFound = this.checkAttachmentFieldValue(stepAssignments[i][0], fieldDef.isArray()))) continue;
                    foundItems.addElement(new VWDesignerValidationItem(stepAssignments[i][0], 1, VWResource.s_incompatibleAttachment, stepDef.getName(), mapName, stepDef.getStepId(), wflDef.getName(), 0));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void checkStepParameters(VWStepDefinition stepDef, String mapName, VWWorkflowDefinition wflDef, Vector foundItems) {
        try {
            VWParameterDefinition[] paramDefs = stepDef.getParameterDefinitions();
            if (paramDefs != null) {
                for (int nIndex = 0; nIndex < paramDefs.length; ++nIndex) {
                    boolean bFound;
                    if (paramDefs[nIndex].getDataType() != 32 || !(bFound = this.checkAttachmentFieldValue(paramDefs[nIndex].getValue(), paramDefs[nIndex].getIsArray()))) continue;
                    foundItems.addElement(new VWDesignerValidationItem(paramDefs[nIndex].getName(), 3, VWResource.s_incompatibleAttachment, stepDef.getName(), mapName, stepDef.getStepId(), wflDef.getName(), 0));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }

    private void checkAssignmentInstructions(VWCompoundStepDefinition stepDef, String mapName, VWWorkflowDefinition wflDef, Vector foundItems) {
        try {
            VWInstructionDefinition[] instructionDefs = stepDef.getInstructions();
            if (instructionDefs != null) {
                for (int nIndex = 0; nIndex < instructionDefs.length; ++nIndex) {
                    String[][] assignments;
                    if (instructionDefs[nIndex].getAction() != 0 || (assignments = VWInstruction.AssignInstructionGetAssignment(instructionDefs[nIndex])) == null) continue;
                    for (int i = 0; i < assignments.length; ++i) {
                        boolean bFound;
                        VWFieldDefinition fieldDef = wflDef.getField(assignments[i][0]);
                        if (fieldDef == null || fieldDef.getFieldType() != 32 || !(bFound = this.checkAttachmentFieldValue(assignments[i][0], fieldDef.isArray()))) continue;
                        foundItems.addElement(new VWDesignerValidationItem(stepDef.getName(), 7, VWResource.s_incompatibleAttachment, null, mapName, stepDef.getStepId(), wflDef.getName(), 0));
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
        }
    }
}

